//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	HILDA non-private dwelling weights
// Objective: 	Assigning weights to residents of nursing homes by using lagged
//				versions of those weights
//
// Created: 	09/04/2021
// Modified: 	16/11/2021
//==============================================================================

clear

**************************
*** Importing the Data ***
**************************

cd "XXXX" // set the content directory here

use HILDA_restricted_combined // importing the HILDA unconfidentialised data

xtset xwaveid wave // declaring the data to be a panel with xwaveid the panel variable and wave the time series variable

local other_weights hhwth hhwths hhwte hhwtes // creating a local macro containing the household and enumerated person weights at both a sample and population level

local rp_weights hhwtrp hhwtrps	// creating a local macro containing the responding person weights at both a sample and population level

*********************
*** Nursing homes ***
*********************

foreach w in `other_weights' {
	    replace `w' = L.`w' if `w' == 0 & L.`w' != . & dodtyp == 1
} // replacing each of the four weights with the first lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `other_weights' {
	    replace `w' = L2.`w' if `w' == 0 & L2.`w' != . & dodtyp == 1
} // replacing each of the four weights with the second lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `other_weights' {
	    replace `w' = L3.`w' if `w' == 0 & L3.`w' != . & dodtyp == 1
} // replacing each of the four weights with the third lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `other_weights' {
	    replace `w' = L4.`w' if `w' == 0 & L4.`w' != . & dodtyp == 1
} // replacing each of the four weights with the fourth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `other_weights' {
	    replace `w' = L5.`w' if `w' == 0 & L5.`w' != . & dodtyp == 1
} // replacing each of the four weights with the fifth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `other_weights' {
	    replace `w' = L6.`w' if `w' == 0 & L6.`w' != . & dodtyp == 1
} // replacing each of the four weights with the sixth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `other_weights' {
	    replace `w' = L7.`w' if `w' == 0 & L7.`w' != . & dodtyp == 1
} // replacing each of the four weights with the seventh lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `other_weights' {
	    replace `w' = L8.`w' if `w' == 0 & L8.`w' != . & dodtyp == 1
} // replacing each of the four weights with the eighth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `other_weights' {
	    replace `w' = L9.`w' if `w' == 0 & L9.`w' != . & dodtyp == 1
} // replacing each of the four weights with the ninth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `other_weights' {
	    replace `w' = L10.`w' if `w' == 0 & L10.`w' != . & dodtyp == 1
} // replacing each of the four weights with the tenth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `other_weights' {
	    replace `w' = L11.`w' if `w' == 0 & L11.`w' != . & dodtyp == 1
} // replacing each of the four weights with the eleventh lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `other_weights' {
	gen new_`w' = `w'
} // generating new weights that include residents of nursing homes

save HILDA_restricted_dodtyp1_weights, replace

***********************************
*** Other non-private dwellings ***
***********************************

foreach w in `other_weights' {
	    replace `w' = L.`w' if `w' == 0 & L.`w' != . & dodtyp == 2
} // replacing each of the four weights with the first lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	    replace `w' = L2.`w' if `w' == 0 & L2.`w' != . & dodtyp == 2
} // replacing each of the four weights with the second lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	    replace `w' = L3.`w' if `w' == 0 & L3.`w' != . & dodtyp == 2
} // replacing each of the four weights with the third lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	    replace `w' = L4.`w' if `w' == 0 & L4.`w' != . & dodtyp == 2
} // replacing each of the four weights with the fourth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	    replace `w' = L5.`w' if `w' == 0 & L5.`w' != . & dodtyp == 2
} // replacing each of the four weights with the fifth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	    replace `w' = L6.`w' if `w' == 0 & L6.`w' != . & dodtyp == 2
} // replacing each of the four weights with the sixth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	    replace `w' = L7.`w' if `w' == 0 & L7.`w' != . & dodtyp == 2
} // replacing each of the four weights with the seventh lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	    replace `w' = L8.`w' if `w' == 0 & L8.`w' != . & dodtyp == 2
} // replacing each of the four weights with the eighth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	    replace `w' = L9.`w' if `w' == 0 & L9.`w' != . & dodtyp == 2
} // replacing each of the four weights with the ninth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	    replace `w' = L10.`w' if `w' == 0 & L10.`w' != . & dodtyp == 2
} // replacing each of the four weights with the tenth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

**********************
*** Lead variables ***
**********************

foreach w in `other_weights' {
	replace `w' = F1.`w' if `w' == 0 & F1.`w' != . & dodtyp == 2
}	// replacing each of the four weights with the first lead if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	replace `w' = F2.`w' if `w' == 0 & F2.`w' != . & dodtyp == 2
}	// replacing each of the four weights with the second lead if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	replace `w' = F3.`w' if `w' == 0 & F3.`w' != . & dodtyp == 2
}	// replacing each of the four weights with the third lead if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	replace `w' = F4.`w' if `w' == 0 & F4.`w' != . & dodtyp == 2
}	// replacing each of the four weights with the fourth lead if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `other_weights' {
	replace new_`w' = `w' if dodtyp == 2
} // generating new weights that include residents of nursing homes

*********************************
*** Responding person weights ***
*********************************

foreach w in `rp_weights' {
	    replace `w' = L.`w' if `w' == 0 & L.`w' != . & L.`w' >= 0 & dodtyp == 1
} // replacing each of the two weights with the first lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `rp_weights' {
	    replace `w' = L2.`w' if `w' == 0 & L2.`w' != . & L2.`w' >= 0 & dodtyp == 1
} // replacing each of the two weights with the second lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `rp_weights' {
	    replace `w' = L3.`w' if `w' == 0 & L3.`w' != . & L3.`w' >= 0 & dodtyp == 1
} // replacing each of the two weights with the third lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `rp_weights' {
	    replace `w' = L4.`w' if `w' == 0 & L4.`w' != . & L4.`w' >= 0 & dodtyp == 1
} // replacing each of the two weights with the fourth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `rp_weights' {
	    replace `w' = L5.`w' if `w' == 0 & L5.`w' != . & L5.`w' >= 0 & dodtyp == 1
} // replacing each of the two weights with the fifth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `rp_weights' {
	    replace `w' = L6.`w' if `w' == 0 & L6.`w' != . & L6.`w' >= 0 & dodtyp == 1
} // replacing each of the two weights with the sixth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `rp_weights' {
	    replace `w' = L7.`w' if `w' == 0 & L7.`w' != . & L7.`w' >= 0 & dodtyp == 1
} // replacing each of the two weights with the seventh lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `rp_weights' {
	    replace `w' = L8.`w' if `w' == 0 & L8.`w' != . & L8.`w' >= 0 & dodtyp == 1
} // replacing each of the two weights with the eighth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `rp_weights' {
	    replace `w' = L9.`w' if `w' == 0 & L9.`w' != . & L9.`w' >= 0 & dodtyp == 1
} // replacing each of the two weights with the ninth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `rp_weights' {
	    replace `w' = L10.`w' if `w' == 0 & L10.`w' != . & L10.`w' >= 0 & dodtyp == 1
} // replacing each of the two weights with the tenth lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `rp_weights' {
	    replace `w' = L11.`w' if `w' == 0 & L11.`w' != . & L11.`w' >= 0 & dodtyp == 1
} // replacing each of the two weights with the eleventh lag if the weight has been set to zero and the individual is a resident of a nursing home

foreach w in `rp_weights' {
	gen new_`w' = `w'
} // generating new weights that include residents of nursing homes

***********************************
*** Other non-private dwellings ***
***********************************

foreach w in `rp_weights' {
	    replace `w' = L.`w' if `w' == 0 & L.`w' != . & L.`w' >= 0 & dodtyp == 2
} // replacing each of the two weights with the first lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	    replace `w' = L2.`w' if `w' == 0 & L2.`w' != . & L2.`w' >= 0 & dodtyp == 2
} // replacing each of the two weights with the second lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	    replace `w' = L3.`w' if `w' == 0 & L3.`w' != . & L3.`w' >= 0 & dodtyp == 2
} // replacing each of the two weights with the third lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	    replace `w' = L4.`w' if `w' == 0 & L4.`w' != . & L4.`w' >= 0 & dodtyp == 2
} // replacing each of the two weights with the fourth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	    replace `w' = L5.`w' if `w' == 0 & L5.`w' != . & L5.`w' >= 0 & dodtyp == 2
} // replacing each of the two weights with the fifth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	    replace `w' = L6.`w' if `w' == 0 & L6.`w' != . & L6.`w' >= 0 & dodtyp == 2
} // replacing each of the two weights with the sixth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	    replace `w' = L7.`w' if `w' == 0 & L7.`w' != . & L7.`w' >= 0 & dodtyp == 2
} // replacing each of the two weights with the seventh lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	    replace `w' = L8.`w' if `w' == 0 & L8.`w' != . & L8.`w' >= 0 & dodtyp == 2
} // replacing each of the two weights with the eighth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	    replace `w' = L9.`w' if `w' == 0 & L9.`w' != . & L9.`w' >= 0 & dodtyp == 2
} // replacing each of the two weights with the ninth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	    replace `w' = L10.`w' if `w' == 0 & L10.`w' != . & L10.`w' >= 0 & dodtyp == 2
} // replacing each of the two weights with the tenth lag if the weight has been set to zero and the individual is a resident of a non-private dwelling

**********************
*** Lead variables ***
**********************

foreach w in `rp_weights' {
	replace `w' = F1.`w' if `w' == 0 & F1.`w' != . & F1.`w' >= 0 & dodtyp == 2
}	// replacing each of the two weights with the first lead if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	replace `w' = F2.`w' if `w' == 0 & F2.`w' != . & F2.`w' >= 0 & dodtyp == 2
}	// replacing each of the two weights with the second lead if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	replace `w' = F3.`w' if `w' == 0 & F3.`w' != . & F3.`w' >= 0 & dodtyp == 2
}	// replacing each of the two weights with the third lead if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	replace `w' = F4.`w' if `w' == 0 & F4.`w' != . & F4.`w' >= 0 & dodtyp == 2
}	// replacing each of the two weights with the fourth lead if the weight has been set to zero and the individual is a resident of a non-private dwelling

foreach w in `rp_weights' {
	replace new_`w' = `w' if dodtyp == 2
} // generating new weights that include residents of nursing homes

keep wave xwaveid new_hhwt* dodtyp	// keeping the relevant variables to be merged with the main dataset

**************************
*** Saving the dataset ***
**************************

drop new_hhwths new_hhwtes new_hhwtrps	// dropping sample level weights

save HILDA_restricted_combined_nonprivate_weights, replace	// saving the dataset